.module/RAM/ABS=0       GEN;

.include    <..\system.k>;

{******************************************************************************
 *
 *  Variables
 *
 ******************************************************************************}

.VAR/DM    StateFlag;

{ dynamic scratchpad variables }
.var

{ fixed variables to be loaded from booted PM }
.var

.var/dm/ram/circ                rx_buf[3];      /* Status + L data + R data */
.var/dm/ram/circ                tx_buf[3];      /* Cmd + L data + R data    */
.var/dm/ram/circ                init_cmds[13];
.var/dm                         stat_flag;

.init tx_buf:   0xc000, 0x0000, 0x0000; /* Initially set MCE        */

.init init_cmds:
        0xc002,
        0xc102,
        0xc288,
        0xc388,
        0xc488,
        0xc588,
        0xc680,
        0xc780,
        0xc850,
        0xc909,
        0xca00,
        0xcc40,
        0xcd00;

{******************************************************************************
 *  Interrupt vector table
 ******************************************************************************}
        jump start;  rti; rti; rti;     {00: reset }
        rti;         rti; rti; rti;     {04: IRQ2 }
        rti;         rti; rti; rti;     {08: IRQL1 }
        rti;         rti; rti; rti;     {0c: IRQL0 }
        ar = dm(stat_flag);             {10: SPORT0 tx }
        ar = pass ar;
        if eq rti;
        jump next_cmd;
        jump input_samples;             {14: SPORT1 rx }
                     rti; rti; rti;
        rti;         rti; rti; rti;     {18: IRQE }
        rti;         rti; rti; rti;     {1c: BDMA }
        jump irq1isr;
                     rti; rti; rti;     {20: SPORT1 tx or IRQ1 }
        rti;         rti; rti; rti;     {24: SPORT1 rx or IRQ0 }
        rti;         rti; rti; rti;     {28: timer }
        rti;         rti; rti; rti;     {2c: power down }


{******************************************************************************
 *  ADSP 2181 intialization
 ******************************************************************************}
start:
        {   shut down sport 0 }
        ax0 = b#0000100000000000;   dm (System_Control_Reg) = ax0;

{   restores monitor timer handler. }
        i7 = 0x3fe8;
        ar = pm (i7, m7);               { px implicit }
        i7 = 0x28;
        pm (i7, m7) = ar;


        i5 = ^rx_buf;
        l5 = %rx_buf;
        i6 = ^tx_buf;
        l6 = %tx_buf;
        i3 = ^init_cmds;
        l3 = %init_cmds;

        m1 = 1;
        m5 = 1;


{================== S E R I A L   P O R T   #0   S T U F F ==================}
        ax0 = b#0000110011010111;   dm (SPORT0_Autobuf) = ax0;

        ax0 = 0;    dm (SPORT0_RFSDIV) = ax0;
        ax0 = 0;    dm (SPORT0_SCLKDIV) = ax0;
        ax0 = b#1000011000001111;   dm (SPORT0_Control_Reg) = ax0;
        ax0 = b#0000000000000111;   dm (SPORT0_TX_Channels0) = ax0;
        ax0 = b#0000000000000111;   dm (SPORT0_TX_Channels1) = ax0;
        ax0 = b#0000000000000111;   dm (SPORT0_RX_Channels0) = ax0;
        ax0 = b#0000000000000111;   dm (SPORT0_RX_Channels1) = ax0;


{============== S Y S T E M   A N D   M E M O R Y   S T U F F ==============}
        ax0 = b#0001100000000000;   dm (System_Control_Reg) = ax0;
        ifc = b#00000011111111;         { clear pending interrupt }
        nop;


        icntl = b#00010;
        mstat = b#1000000;

{******************************************************************************
 *  ADSP 1847 Codec intialization
 ******************************************************************************}

        {   clear flag }
        ax0 = 1;
        dm(stat_flag) = ax0;

        {   enable transmit interrupt }
        ena ints;
        imask = b#0001000000;

        ax0 = dm (i6, m5);          { start interrupt }
        tx0 = ax0;

check_init:
        ax0 = dm (stat_flag);       { wait for entire init }
        af = pass ax0;              { buffer to be sent to }
        if ne jump check_init;      { the codec            }

        ay0 = 2;
check_aci1:
        ax0 = dm (rx_buf);          { once initialized, wait for codec }
        ar = ax0 and ay0;           { to come out of autocalibration }
        if eq jump check_aci1;      { wait for bit set }

check_aci2:
        ax0 = dm (rx_buf);          { wait for bit clear }
        ar = ax0 and ay0;
        if ne jump check_aci2;
        idle;

        ay0 = 0xbf3f;               { unmute left DAC }
        ax0 = dm (init_cmds + 6);
        ar = ax0 AND ay0;
        dm (tx_buf) = ar;
        idle;

        ax0 = dm (init_cmds + 7);   { unmute right DAC }
        ar = ax0 AND ay0;
        dm (tx_buf) = ar;
        idle;


        ifc = b#00000011111111;     { clear any pending interrupt }
        nop;


{   end codec initialization, begin filter demo initialization }



        l0=0; l1=0; l2=0; l3=0; l4=0; l7=0;
        i0=^dial_list;
        m0=1;
        m7=1; l7=0;         { used by boot_sine routine }

        imask = b#0000100101;       { enable rx0 interrupt }

        jump iSend;         {   send dummy to signal ready }

{------------------------------------------------------------------------------
 -
 -  command loop.
 -
 ------------------------------------------------------------------------------}
again:  { any thing from host ?}
        ar = dm (CHAR_WAITING_FLAG);            { kbhit () }
        none = pass ar;
        if ne jump again;

{ has something }
        i4 = dm (PTR_TO_GET_CHAR);        { get int }
        call (i4);
        if lt jump again; { time out }

iSend:  i4 = dm (PTR_TO_OUT_CHAR);        { send int }
        call (i4);

{ wait for char to go out }
wt:
        ar = dm (CHAR_SEND_DONE_FLAG);
        none = pass ar;
        if eq jump wt;

        toggle fl1;
        jump again;

{------------------------------------------------------------------------------
 -  SPORT0 interrupt handler  (called at 48KHz)
 ------------------------------------------------------------------------------}
input_samples:
        ena sec_reg;                { use shadow register bank }

        rti;



{------------------------------------------------------------------------------
 -  transmit interrupt used for Codec initialization
 ------------------------------------------------------------------------------}
next_cmd:
        ena sec_reg;
        ax0 = dm (i3, m1);          { fetch next control word and }
        dm (tx_buf) = ax0;          { place in transmit slot 0    }
        ax0 = i3;
        ay0 = ^init_cmds;
        ar = ax0 - ay0;
        if gt rti;                  { rti if more control words still waiting }
        ax0 = 0xaf00;               { else set done flag and }
        dm (tx_buf) = ax0;          { remove MCE if done initialization }
        ax0 = 0;
        dm (stat_flag) = ax0;       { reset status flag }
        rti;


{******************************************************************************
 *  A high to low transition on flag_in signifies the start bit; it also
 *  triggers IRQ1 ISR which then turn on timer if the timer is off.  This is
 *  at to most 1/3 bit period too late but we should still catch the byte.
 ******************************************************************************}
irq1isr:
        pop sts;
        ena timer;              { start timer now }
        rts;                    { note rts }

.endmod;
