.model small
dosseg
comm_data equ 03f8h
comm_brl  equ 03f8h
comm_ier  equ 03f9h
comm_brh  equ 03f9h
comm_lcr  equ 03fbh
comm_mcr  equ 03fch
comm_stat equ 03fdh

comm_int  equ 0ch
int_mask  equ 010h
pic_mask  equ 021h
pic_eoi	  equ 020h
.data

comm_seg  dw	0
comm_off  dw	0

.code
begin:mov ah,035h
    mov al,comm_int
    int 021h
    mov comm_seg,es
    mov comm_off,bx

    mov dx,comm_lcr		;/* need to set bit 7 to 1  */
    mov al,080h		 	;/* to set baud rate */
    out dx,al

    mov dx,comm_brl		;/* set the baud rates */
    mov al,030h
    out dx,al
    mov dx,comm_brh
    mov al,000h
    out dx,al

    mov dx,comm_lcr		;/* set bit 7 back to 0 */
    mov al,033h			;/* also 8,N,1 operation */
    out dx,al

    mov dx,comm_mcr		;/* modem control register */
    mov al,0bh
    out dx,al

    mov dx,comm_ier		;/* interrupt enable */
    mov al,0fh
    out dx,al

    in al,pic_mask
    and al,not int_mask
    out pic_mask,al

    mov al,comm_int
    mov dx,offset comm_new	;/* & set */

    mov bx,seg comm_new
    push ds
    mov ds,bx
    mov ah,025h
    int 021h
    pop ds

wot:mov ah,01h
    int 16h
    jnz wot

comm_unin:in al,pic_mask
    or al,int_mask
    out pic_mask,al

    push ds
    mov dx,comm_off
    mov ds,comm_seg
    mov ah,025h
    mov al,comm_int
    int 021h
    pop ds
    mov ah,04ch
    int 021h

comm_new:
    pushf
    push es
    push ax
    push bx
    mov ax,0b800h
    mov es,ax
    xor bx,bx
    mov al,065h

    mov es:[00000],al

    mov dx,comm_data
    in al,dx
    mov es:[00002],al
    mov es:[00003],al

    mov dx,061h
    mov al,0ffh
    out dx,al

    mov al,020h
    out pic_eoi,al		;/* signal the interrupt controller */
    pop bx
    pop ax
    pop es
    popf
    iret
end




