#include <stdio.h>
#include <string.h>
#include "exe2dfs.h"
#include "flashfnc.h"
//#include "upload.h"
//#include "bootload.h"
//#include "pcio.h"
//#include "serial.h"

int write_segment(int,int);

unsigned int hi_start,lo_start,hi_len,lo_len;

unsigned char segment_data[16384];
unsigned int segment_data_pos;

int data_segs=0,data_size=0;
int prog_segs=0,prog_size=0;

FILE *fi_in,*fi_out;

int exe2dfs(void)
{
	char filename[80],buf[80];
	int i,done=0,state=0,datawords=0,getaddress=0,readintvecs=0;

	char initstring    [5];
	char endstring     [5];
	char prgaddrstring [5] = "@PA";
	char dataaddrstring[5] = "@DA";

	sprintf(initstring,"%c%ci0",27,27);
	sprintf( endstring,"%c%co0",27,27);

	// Open files
	printf("Enter .exe filename:");
	gets(filename);
	fi_in=fopen(filename,"rb");
	if(fi_in==NULL)
	{
		printf("couldn't open %s for binary read.\n",filename);
		return(0);
	}

	printf("Enter .dfs filename:");
	gets(filename);
	fi_out=fopen(filename,"wb");
	if(fi_out==NULL)
	{
		printf("couldn't open %s for binary write.\n",filename);
		return(0);
	}

	// parse through file
	do
	{
		/* Read a line from the file */
		fgets(buf,75,fi_in);

		switch(state)
		{

			case 0:// initial state ------------------------------------
			if(!strncmp(buf,initstring,3))
			{
				printf("initstring found.\n");
				state=1;
			} else
			{
				printf("input file not a DSP exectuable.\n",filename);
				done=1;
			}
			break;


			case 1:// looking for segment header -----------------------
			if(!strncmp(buf,prgaddrstring,3))
			{
				printf("prg seg:  ");
				segment_data_pos=0;
				datawords=0;
				getaddress=1;
				state=2;
			} else
			if(!strncmp(buf,dataaddrstring,3))
			{
				printf("data seg:  ");
				segment_data_pos=0;
				datawords=0;
				getaddress=1;
				state=3;
			} else
			if(!strncmp(buf,endstring,3))
			{
				printf("end.\n");
				write_segment(0,0);
				done=1;
			} else
			{
				for(i=0;i<strlen(buf);i++)printf("%d ",buf[i]);
				printf("No recognizeable segment header found!\n");
				done=1;
			}
			break;


			case 2:// loading prg words ---------------------------
			// look for end of segment
			if(buf[0]=='#')
			{
				printf("size %d words.\n",datawords);
				write_segment(3,datawords);
				prog_segs++;
				prog_size+=datawords;
				state=1;
			} else
			{
				// if this is the first entry, read address bytes
				if(getaddress==1)
				{ // read two bytes
					hi_start=conv_from_hex(buf[0],buf[1]);
					lo_start=conv_from_hex(buf[2],buf[3]);
					getaddress=0;

					// relocate interrupt vectors
					if( (hi_start==0) && (lo_start==0) )
					{
						printf("relocating interrupt vectors.\n");
						readintvecs = 1;
						hi_start    = 0x3f;
						lo_start	  = 0xc0;
					}
				}
				else
				{ // read three bytes
					read_and_conv(buf,3);
					datawords++;

					// done reading intvecs?
					if( (readintvecs==1) && (datawords==48) )
					{
						// write out "interrupt vector" segment
						write_segment(3,datawords);
						prog_segs++;
						prog_size+=datawords;

						// resume reading program data into new program segment
						hi_start         = 0x00;
						lo_start	       = 0x30;
						segment_data_pos = 0;
						datawords        = 0;
						getaddress       = 0;
						readintvecs			 = 0;
						state            = 2;
					}
				}
			}
			break;


			case 3:// loading data words -------------------------
			if(buf[0]=='#')
			{
				printf("size %d words.\n",datawords);
				write_segment(2,datawords);
				data_segs++;
				data_size+=datawords;
				state=1;
			} else
			{
				// if this is the first entry, read address bytes
				if(getaddress==1)// read two bytes
				{
					hi_start=conv_from_hex(buf[0],buf[1]);
					lo_start=conv_from_hex(buf[2],buf[3]);
					getaddress=0;
				}
				else
				{ // read two bytes
					read_and_conv(buf,2);
					datawords++;
				}
			}
			break;


		}

	} while(!done);


	fclose(fi_in);
	fclose(fi_out);
	printf("File created.\n");
	printf("Data Segments: %d\tData Size: %d words\n",data_segs,data_size);
	printf("Prog Segments: %d\tProg Size: %d words\n",prog_segs,prog_size);
	return(1);
}

int write_segment(int len,int datawords)
{
	unsigned char header[80],type;
	int 					i=0,j,k=0,l;

	// generate segment header --------------------------------------------
	hi_len = datawords/256;
	lo_len = datawords%256;

	// length
	header[i++]=hi_len;
	header[i++]=lo_len;

	// start address
	header[i++]=hi_start;
	header[i++]=lo_start;

	// type
	switch(len)
	{
		case 0:		type=0;		// end segment header
							break;

		case 2:		type=1;		// data segment (16-bit words)
							break;

		case 3:		type=2;		// program segment (24-bit words)
							break;
	}
	header[i++]=type;

	// write header
	for(l=0;l<i;l++)
		fprintf(fi_out,"%c",header[l]);

	// write segment data -------------------------------------------------
	for(j=0;j<datawords;j++)
		for(l=0;l<len;l++)
			fprintf(fi_out,"%c",segment_data[k++]);

	return(1);
}

unsigned char conv_from_hex(char a,char b)
{
	return((hex_to_int(a)*16) + hex_to_int(b));
}

void read_and_conv(char *buf, int len)
{
	int i,j=0;
	unsigned char;
	int value;

	for(i=0;i<len;i++,j+=2)
	{
		value=conv_from_hex(buf[j],buf[j+1]);
		segment_data[segment_data_pos++]=value;
	}
}
