.module/RAM/ABS=0       NLWORKS;

.include    <..\system.k>;

{******************************************************************************
 *
 *  Variables
 *
 ******************************************************************************}

.CONST CHANS=2;
.CONST CHAN_PARAM_LEN=4;
.CONST CHAN_PARAM_LEN_DIV2=CHAN_PARAM_LEN/2;
.CONST CHAN_SCRATCH_SIZE=CHANS*CHAN_PARAM_LEN;

.VAR/DM    StateFlag;

.var    wave_index [4];
.init   wave_index: ^wave_sin, ^wave_saw, ^wave_squ, ^wave_tri;

{ dynamic scratchpad variables }
.var    input1,input2,
    midi_ch,                    { MIDI channel }
    midi_vel,                   { MIDI velocity }
    midi_note,                  { MIDI note }
    midi_cont,                  { MIDI controller number }
    midi_val,                   { MIDI controller value }
    midi_trash,                 { garbage }
    sum1, sum2,                 { row and col phase accumulators }
    sin1, sin2,                 { returned values from calling sin }
    time_on,                    { software counter to manage tone ON time }
    time_off,                   { software counter to manage tone OFF time }
    state,                      { MIDI state machine }
    wave_scratch[CHAN_SCRATCH_SIZE], { place to render waveforms }
    synth_out;                       { place to add up waveforms }
    
    
{ fixed variables to be loaded from booted PM }
.var    scale,                      { attenuation of each sine before summing }
    sign_dura_ms,               { signal duration time in millisec }
    interdigit_ms,              { interdigit time in millisec }
    freqtab[128],               { frequency table }
    wave_sin[256],                 { sine wave }
    wave_saw[256],                 { trangle wave }
    wave_squ[256],                 { trangle wave }
    wave_tri[256];                 { trangle wave }


.include   <freqtab.h>; 
.include   <wave_sin.h>;
.include   <wave_saw.h>;
.include   <wave_squ.h>;
.include   <wave_tri.h>;

.init      scale:          h#FFFF;
.init      sign_dura_ms:   h#0064;     {  100 ms (in hex) }
.init      interdigit_ms:  h#0064;     {  100 ms (in hex) }

.var/dm/ram/circ                rx_buf[3];      /* Status + L data + R data */
.var/dm/ram/circ                tx_buf[3];      /* Cmd + L data + R data    */
.var/dm/ram/circ                init_cmds[13];
.var/dm                         stat_flag;

.init tx_buf:   0xc000, 0x0000, 0x0000; /* Initially set MCE        */

.init init_cmds:
        0xc002,     {
                        Left input control reg
                        b7-6: 0=left line 1
                              1=left aux 1
                              2=left line 2
                              3=left line 1 post-mixed loopback
                        b5-4: res
                        b3-0: left input gain x 1.5 dB
                    }
        0xc102,     {
                        Right input control reg
                        b7-6: 0=right line 1
                              1=right aux 1
                              2=right line 2
                              3=right line 1 post-mixed loopback
                        b5-4: res
                        b3-0: right input gain x 1.5 dB
                    }
        0xc288,     {
                        left aux 1 control reg
                        b7  : 1=left aux 1 mute
                        b6-5: res
                        b4-0: gain/atten x 1.5, 08= 0dB, 00= 12dB
                    }
        0xc388,     {
                        right aux 1 control reg
                        b7  : 1=right aux 1 mute
                        b6-5: res
                        b4-0: gain/atten x 1.5, 08= 0dB, 00= 12dB
                    }
        0xc488,     {
                        left aux 2 control reg
                        b7  : 1=left aux 2 mute
                        b6-5: res
                        b4-0: gain/atten x 1.5, 08= 0dB, 00= 12dB
                    }
        0xc588,     {
                        right aux 2 control reg
                        b7  : 1=right aux 2 mute
                        b6-5: res
                        b4-0: gain/atten x 1.5, 08= 0dB, 00= 12dB
                    }
        0xc680,     {
                        left DAC control reg
                        b7  : 1=left DAC mute
                        b6  : res
                        b5-0: attenuation x 1.5 dB
                    }
        0xc780,     {
                        right DAC control reg
                        b7  : 1=right DAC mute
                        b6  : res
                        b5-0: attenuation x 1.5 dB
                    }
        0xc85c,     {
                        data format register
                        b7  : res
                        b5-6: 0=8-bit unsigned linear PCM
                              1=8-bit u-law companded
                              2=16-bit signed linear PCM
                              3=8-bit A-law companded
                        b4  : 0=mono, 1=stereo
                        b0-3: 0=  8.
                              1=  5.5125
                              2= 16.
                              3= 11.025
                              4= 27.42857
                              5= 18.9
                              6= 32.
                              7= 22.05
                              8=   .
                              9= 37.8
                              a=   .
                              b= 44.1
                              c= 48.
                              d= 33.075
                              e=  9.6
                              f=  6.615
                       (b0) : 0=XTAL1 24.576 MHz; 1=XTAL2 16.9344 MHz
                    }
        0xc909,     {
                        interface configuration reg
                        b7-4: res
                        b3  : 1=autocalibrate
                        b2-1: res
                        b0  : 1=playback enabled
                    }
        0xca00,     {
                        pin control reg
                        b7  : logic state of pin XCTL1
                        b6  : logic state of pin XCTL0
                        b5  : master - 1=tri-state CLKOUT
                              slave  - x=tri-state CLKOUT
                        b4-0: res
                    }
        0xcc40,     {
                        miscellaneous information reg
                        b7  : 1=16 slots per frame, 0=32 slots per frame
                        b6  : 1=2-wire system, 0=1-wire system
                        b5-0: res
                    }
        0xcd00;     {
                        digital mix control reg
                        b7-2: attenuation x 1.5 dB
                        b1  : res
                        b0  : 1=digital mix enabled
                    }

{******************************************************************************
 *
 *  Interrupt vector table
 *
 ******************************************************************************}
        jump start;  rti; rti; rti;     {00: reset }
        rti;         rti; rti; rti;     {04: IRQ2 }
        rti;         rti; rti; rti;     {08: IRQL1 }
        rti;         rti; rti; rti;     {0c: IRQL0 }
        ar = dm(stat_flag);             {10: SPORT0 tx }
        ar = pass ar;
        if eq rti;
        jump next_cmd;
        jump input_samples;             {14: SPORT1 rx }
                     rti; rti; rti;
        rti;         rti; rti; rti;     {18: IRQE }
        rti;         rti; rti; rti;     {1c: BDMA }
        jump irq1isr;
                     rti; rti; rti;     {20: SPORT1 tx or IRQ1 }
        rti;         rti; rti; rti;     {24: SPORT1 rx or IRQ0 }
        rti;         rti; rti; rti;     {28: timer }
        rti;         rti; rti; rti;     {2c: power down }


{******************************************************************************
 *
 *  ADSP 2181 intialization
 *
 ******************************************************************************}
start:
        {   shut down sport 0 }
        ax0 = b#0000100000000000;   dm (System_Control_Reg) = ax0;

{   restores monitor timer handler. }
        i7 = 0x3fe8;
        ar = pm (i7, m7);               { px implicit }
        i7 = 0x28;
        pm (i7, m7) = ar;


        i5 = ^rx_buf;
        l5 = %rx_buf;
        i6 = ^tx_buf;
        l6 = %tx_buf;
        i3 = ^init_cmds;
        l3 = %init_cmds;

        m1 = 1;
        m5 = 1;


{================== S E R I A L   P O R T   #0   S T U F F ==================}
        ax0 = b#0000110011010111;   dm (SPORT0_Autobuf) = ax0;
            {   |||!|-/!/|-/|/|+- receive autobuffering 0=off, 1=on
                |||!|  ! |  | +-- transmit autobuffering 0=off, 1=on
                |||!|  ! |  +---- | receive m?
                |||!|  ! |        | m5
                |||!|  ! +------- ! receive i?
                |||!|  !          ! i5
                |||!|  !          !
                |||!|  +========= | transmit m?
                |||!|             | m5
                |||!+------------ ! transmit i?
                |||!              ! i6
                |||!              !
                |||+============= | BIASRND MAC biased rounding control bit
                ||+-------------- 0
                |+--------------- | CLKODIS CLKOUT disable control bit
                +---------------- 0
            }

        ax0 = 0;    dm (SPORT0_RFSDIV) = ax0;
            {   RFSDIV = SCLK Hz/RFS Hz - 1 }
        ax0 = 0;    dm (SPORT0_SCLKDIV) = ax0;
            {   SCLK = CLKOUT / (2  (SCLKDIV + 1) }
        ax0 = b#1000011000001111;   dm (SPORT0_Control_Reg) = ax0;
            {   multichannel
                ||+--/|!||+/+---/ | number of bit per word - 1
                |||   |!|||       | = 15
                |||   |!|||       |
                |||   |!|||       |
                |||   |!||+====== ! 0=right just, 0-fill; 1=right just, signed
                |||   |!||        ! 2=compand u-law; 3=compand A-law
                |||   |!|+------- receive framing logic 0=pos, 1=neg
                |||   |!+-------- transmit data valid logic 0=pos, 1=neg
                |||   |+========= RFS 0=ext, 1=int
                |||   +---------- multichannel length 0=24, 1=32 words
                ||+-------------- | frame sync to occur this number of clock
                ||                | cycle before first bit
                ||                |
                ||                |
                |+--------------- ISCLK 0=ext, 1=int
                +---------------- multichannel 0=disable, 1=enable
            }
            {   non-multichannel
                |||!|||!|||!+---/ | number of bit per word - 1
                |||!|||!|||!      | = 15
                |||!|||!|||!      |
                |||!|||!|||!      |
                |||!|||!|||+===== ! 0=right just, 0-fill; 1=right just, signed
                |||!|||!||+------ ! 2=compand u-law; 3=compand A-law
                |||!|||!|+------- receive framing logic 0=pos, 1=neg
                |||!|||!+-------- transmit framing logic 0=pos, 1=neg
                |||!|||+========= RFS 0=ext, 1=int
                |||!||+---------- TFS 0=ext, 1=int
                |||!|+----------- TFS width 0=FS before data, 1=FS in sync
                |||!+------------ TFS 0=no, 1=required
                |||+============= RFS width 0=FS before data, 1=FS in sync
                ||+-------------- RFS 0=no, 1=required
                |+--------------- ISCLK 0=ext, 1=int
                +---------------- multichannel 0=disable, 1=enable
            }


        ax0 = b#0000000000000111;   dm (SPORT0_TX_Channels0) = ax0;
            {   ^15          00^   transmit word enables: channel # == bit # }
        ax0 = b#0000000000000111;   dm (SPORT0_TX_Channels1) = ax0;
            {   ^31          16^   transmit word enables: channel # == bit # }
        ax0 = b#0000000000000111;   dm (SPORT0_RX_Channels0) = ax0;
            {   ^15          00^   receive word enables: channel # == bit # }
        ax0 = b#0000000000000111;   dm (SPORT0_RX_Channels1) = ax0;
            {   ^31          16^   receive word enables: channel # == bit # }


{============== S Y S T E M   A N D   M E M O R Y   S T U F F ==============}
        ax0 = b#0001100000000000;   dm (System_Control_Reg) = ax0;
            {   +-/!||+-----/+-/- | program memory wait states
                |  !|||           | 0
                |  !|||           |
                |  !||+---------- 0
                |  !||            0
                |  !||            0
                |  !||            0
                |  !||            0
                |  !||            0
                |  !||            0
                |  !|+----------- SPORT1 1=serial port, 0=FI, FO, IRQ0, IRQ1,..
                |  !+------------ SPORT1 1=enabled, 0=disabled
                |  +============= SPORT0 1=enabled, 0=disabled
                +---------------- 0
                                  0
                                  0
            }



        ifc = b#00000011111111;         { clear pending interrupt }
        nop;


        icntl = b#00010;
            {     ||||+- | IRQ0: 0=level, 1=edge
                  |||+-- | IRQ1: 0=level, 1=edge
                  ||+--- | IRQ2: 0=level, 1=edge
                  |+---- 0
                  |----- | IRQ nesting: 0=disabled, 1=enabled
            }


        mstat = b#1000000;
            {     ||||||+- | Data register bank select
                  |||||+-- | FFT bit reverse mode (DAG1)
                  ||||+--- | ALU overflow latch mode, 1=sticky
                  |||+---- | AR saturation mode, 1=saturate, 0=wrap
                  ||+----- | MAC result, 0=fractional, 1=integer
                  |+------ | timer enable
                  +------- | GO MODE
            }





{******************************************************************************
 *
 *  ADSP 1847 Codec intialization
 *
 ******************************************************************************}

        {   clear flag }
        ax0 = 1;
        dm(stat_flag) = ax0;

        {   enable transmit interrupt }
        ena ints;
        imask = b#0001000000;
            {     |||||||||+ | timer
                  ||||||||+- | SPORT1 rec or IRQ0
                  |||||||+-- | SPORT1 trx or IRQ1
                  ||||||+--- | BDMA
                  |||||+---- | IRQE
                  ||||+----- | SPORT0 rec
                  |||+------ | SPORT0 trx
                  ||+------- | IRQL0
                  |+-------- | IRQL1
                  +--------- | IRQ2
            }


        ax0 = dm (i6, m5);          { start interrupt }
        tx0 = ax0;

check_init:
        ax0 = dm (stat_flag);       { wait for entire init }
        af = pass ax0;              { buffer to be sent to }
        if ne jump check_init;      { the codec            }

        ay0 = 2;
check_aci1:
        ax0 = dm (rx_buf);          { once initialized, wait for codec }
        ar = ax0 and ay0;           { to come out of autocalibration }
        if eq jump check_aci1;      { wait for bit set }

check_aci2:
        ax0 = dm (rx_buf);          { wait for bit clear }
        ar = ax0 and ay0;
        if ne jump check_aci2;
        idle;

        ay0 = 0xbf3f;               { unmute left DAC }
        ax0 = dm (init_cmds + 6);
        ar = ax0 AND ay0;
        dm (tx_buf) = ar;
        idle;

        ax0 = dm (init_cmds + 7);   { unmute right DAC }
        ar = ax0 AND ay0;
        dm (tx_buf) = ar;
        idle;
        ifc = b#00000011111111;     { clear any pending interrupt }
        nop;


{   end codec initialization}

{ ------------------------------------ begin synthesizer initialization }
myinit:
        l0=0; l1=0; l2=0; l3=0; l4=0; l7=0;
        m0=1;
        m7=1; l7=0;         { used by boot_sine routine }
        dm(state)=m0;       { start up in state 1 (i.e. dial tone) }
        
        { init all waveforms to be sine waves }
        ax0=^wave_scratch;
        ay0=3;
        ar=ax0+ay0;
        m0=CHAN_PARAM_LEN;
        i0=ar;
        
        cntr=CHANS;
        ax1=^wave_sin;
        do initsines until ce;

initsines:
        dm(i0,m0)=ax1;
        
        
        

        imask = b#0000100101;       { enable rx0 interrupt }
            {     |||||||||+ | timer
                  ||||||||+- | SPORT1 rec or IRQ0
                  |||||||+-- | SPORT1 trx or IRQ1
                  ||||||+--- | BDMA
                  |||||+---- | IRQE
                  ||||+----- | SPORT0 rec
                  |||+------ | SPORT0 trx
                  ||+------- | IRQL0
                  |+-------- | IRQL1
                  +--------- | IRQ2
            }

        jump again;

{------------------------------------------------------------------------------
 -
 -  command loop.
 -
 ------------------------------------------------------------------------------}
again:  { any thing from host ?}
        ar = dm (CHAR_WAITING_FLAG);            { kbhit () }
        none = pass ar;
        if ne jump again;

{ has something }

        { determine "state" of state machine }
        ax0=dm(state);ay0=1;ar=ax0-ay0;if eq jump idle1;
        
        { MIDI Note on messages }
        ax0=dm(state);ay0=3;ar=ax0-ay0;if eq jump gotvel;
        ax0=dm(state);ay0=4;ar=ax0-ay0;if eq jump gotnote;
        
        { MIDI Controller messages }
        ax0=dm(state);ay0=5;ar=ax0-ay0;if eq jump contr2;
        ax0=dm(state);ay0=6;ar=ax0-ay0;if eq jump contr3;
        
        jump again;

{ idle! }
idle1:
        i4 = dm (PTR_TO_GET_CHAR);call (i4);
        if lt jump again; { time out }

        ay0 = 90; { 'Z' }              none = ax1 - ay0;if eq rts; { go back to monitor. }
        
        { look for MIDI note on messages }
        ay0 = 144;{ note on =1001xxxx} none = ax1 - ay0;if eq jump noteon1;
        ay0 = 145;{ 10010001 = ch one} none = ax1 - ay0;if eq jump noteon1;
        
        { look for MIDI Controller messages }
        ay0 = 176;{ control =1011xxxx} none = ax1 - ay0;if eq jump contr1;
        ay0 = 177;{ 10110001= ch one } none = ax1 - ay0;if eq jump contr1;

        { print an 'X' if any other byte code received }
        dm(midi_trash)=ax1;
        ax1 = 88;          call nSend;
        ax1=dm(midi_trash);call nSend;

        jump again;

{ -------------------------------------------------- handle MIDI Note on message }
noteon1: { MIDI note on }
        
        ay1= 15;
        ar = ax1 and ay1;
        dm(midi_ch)=ar;
        
        {print 'on' for note on }
        ax1 = 111; { 'o' } call nSend;
        ax1 = 110; { 'n' } call nSend;
        ax1 = dm(midi_ch); call nSend;
        
        ar = 3;  dm(state)=ar;
        jump again;

gotvel: { MIDI velocity }

        i4 = dm (PTR_TO_GET_CHAR);call (i4);
        if lt jump again; { time out }
        dm(midi_vel)=ax1;

        {print 've' for velocity }
        ax1 = 118; { 'v' } call nSend;
        ax1 = 101; { 'e' } call nSend;
        ax1 = dm(midi_vel);call nSend;

        ar = 4;dm(state)=ar;
        jump again;

gotnote:{MIDI note}

        i4 = dm(PTR_TO_GET_CHAR);call (i4);
        if lt jump again; { time out }
        dm(midi_note)=ax1;

        ax1 = 110; { 'n' } call nSend;
        ax1 = 111; { 'o' } call nSend;
        ax1 =dm(midi_note);call nSend;
        call newsound;
        
        ar = 1;dm(state)=ar;
        jump again;

{ -------------------------------------------------- handle MIDI Control message }
contr1: { MIDI control on }
        
        ay1= 15;
        ar = ax1 and ay1;
        dm(midi_ch)=ar;
        
        { print 'co' for control }
        ax1 =  99; { 'c' } call nSend;
        ax1 = 111; { 'o' } call nSend;
        ax1 = dm(midi_ch); call nSend;
        
        ar = 5;  dm(state)=ar;
        jump again;

contr2: { MIDI controller number }

        i4 = dm (PTR_TO_GET_CHAR);call (i4);
        if lt jump again; { time out }
        dm(midi_cont)=ax1;

        { print 'no' for number }
        ax1 = 110; { 'n' } call nSend;
        ax1 = 111; { 'o' } call nSend;
        ax1 = dm(midi_cont);call nSend;

        ar = 6;dm(state)=ar;
        jump again;

contr3: { MIDI control value }

        i4 = dm(PTR_TO_GET_CHAR);call (i4);
        if lt jump again; { time out }
        dm(midi_val)=ax1;

        { print 'va' for value }
        ax1 = 118; { 'v' } call nSend;
        ax1 =  97; { 'a' } call nSend;
        ax1 = dm(midi_val);call nSend;
        
        { um, now what do we do with it! }
        { we write the waveform pointer with it! }
        ax1 = dm(midi_cont);
        ay1 = 0;none = ax1-ay1;if eq jump cont_wave_number;
        
contr3_done:

        { return to idle state }
        ar = 1;dm(state)=ar;
        jump again;

cont_wave_number:
        { get controller value }
        ax1 = dm(midi_val);
        
        { get i0 to point to wave_form_address in correct channel }
        ar=^wave_scratch;
        ay0 = 3;
        ar = ar+ay0;
        
        { offset }
        mx0=dm(midi_ch);
        my0=CHAN_PARAM_LEN_DIV2;
        mr=mx0*my0(UU);
        ay0=mr0;
        ar=ar+ay0;
        i0=ar;  
        
        { get pointer to the proper waveform }
        ay0= ^wave_index;
        ar = ax1 + ay0;         { add waveform number to wave_index base }
        i1 = ar;                
        ax0 = dm(i1,m1);        { lookup address from wave_index }
        
        { write wave_form_address }
        dm(i0,m0)=ax0;

        jump contr3_done;

{------------------------------------------------------------------------------}
newsound:   
        { reset wave position }
        
        i0 = ^wave_scratch;
        mx0 = CHAN_PARAM_LEN;
        my0 = dm(midi_ch); ay0=0;
        mr = mx0*my0(UU);
        sr = lshift mr0 by -1(lo);
        m0 = sr0;
        l0 = 0;
        ax1=dm(i0,m0);
        m0=1;
        dm(i0,m0)=0;
        
        jump skip_print;

        { print out midi_note }
        ax1 = 109; call nSend;
        ax1 = 110; call nSend;
        ax1 = dm(midi_note); call nSend;
        
        { print out wave delta }
        ax1 = 100; call nSend;          { d }
        ax1 = 101; call nSend;          { e }
        
skip_print:

        { load wave delta }
        i1=^freqtab;
        l1=0;
                                                          ax1=dm(midi_note);
        m1=ax1;
        ay1=dm(i1,m1);
        ay1=dm(i1,m1);
        
        { store wave delta }
        dm(i0,m0)=ay1;
        
        { print wave delta }
        ax1 = ay1; call nSend;          { lo byte }
        ar  = ax1; 
        sr  = lshift ar by -8 (lo);
        ax1 = sr0; call nSend;          { hi byte }
        
        rts;

{------------------------------------------------------------------------------
 -
 -  SPORT0 interrupt handler  (called at 48Khz)
 -
 ------------------------------------------------------------------------------}
input_samples:
        { jump thatwasfun; }
        ena sec_reg;                { use shadow register bank }

        ax1 = dm(rx_buf +1);
        mx1 = dm(rx_buf +2);
        dm(input1)=ax1;
        dm(input2)=mx1;

        { render voices }

        l0=0;
        l1=0;

        cntr=CHANS;                 { number of voices }
        i0=^wave_scratch;       { start of wave data area }

do render_voice until ce;

        {---------------------------------------- render wave1's }
        
        { get current wave phase }
        m0 = 1;
        ax1= dm(i0,m0);
        
        { get wave delta }
        m0 = -1;
        ay1= dm(i0,m0);
        
        { advance wave1's phase }
        ar = ax1+ay1;
        m0 = 3;
        dm(i0,m0)=ar;
        
        { get pointer to waveform }
        m0 = -1;
        ax0 = dm(i0,m0);
                
        { lookup sample using updated wave position }        
        { ar holds phase at this point }
        { ax0 holds pointer to beginning of waveform }
        sr = lshift ar by -8 (lo);
        ay0= sr0;
        ar = ax0 + ay0;
        i1 = ar;
        ar = dm(i1,m1);
        
        {---------------------------------------- store voice's output value }
        m0=2;
render_voice:dm(i0,m0)=ar;
        
        {---------------------------------------- sum and output left & right channels }
        cntr = CHANS;
        mr =0;
        i0=^wave_scratch;
        m0=2;
        ax1=dm(i0,m0);
        m0=CHAN_PARAM_LEN;
        
        { add up voices' output values }
do sum_voices until ce;
        my0=0x3fff;
        mx0=dm(i0,m0);
sum_voices:mr=mr+mx0*my0(SS);
        if mv sat mr;
        
        { write out value }        
        dm (tx_buf + 2) = mr1;
        dm (tx_buf + 1) = mr1;
        
thatwasfun:
        rti;    

{------------------------------------------------------------------------------}
{
    Included in DTMF source code July 3, 1990 B.W.
    Sine Approximation                Y = boot_sin(x)
    Calling Parameters
        AX0 = x in scaled 1.15 format
        M7 = 1
        L7 = 0
    Return Values           AR = y in 1.15 format
    Altered Registers       AY0,AF,AR,MY1,MX1,MF,MR,SR,I3
    Computation Time        25 cycles}
.ENTRY  boot_sin;

.VAR/PM sin_coeff[5];
.INIT   sin_coeff: H#324000, H#005300, H#AACC00, H#08B700, H#1CCE00;

boot_sin:
    I7=^sin_coeff;                      {Pointer to coeff. buffer}
    AY0=H#4000;
    AR=AX0, AF=AX0 AND AY0;             {Check 2nd or 4th quad.}
    IF NE AR=-AX0;                      {If yes, negate input}
    AY0=H#7FFF;
    AR=AR AND AY0;                      {Remove sign bit}
    MY1=AR;
    MF=AR*MY1 (RND), MX1=PM(I7,M7);     {MF = x2}
    MR=MX1*MY1 (SS), MX1=PM(I7,M7);     {MR = C1x}
    CNTR=3;
    { DO approx UNTIL CE; }
top_approx:     MR=MR+MX1*MF (SS);
approx:         MF=AR*MF (RND), MX1=PM(I7,M7);
        if not ce jump top_approx;
    MR=MR+MX1*MF (SS);
    SR=ASHIFT MR1 BY 3 (HI);
    SR=SR OR LSHIFT MR0 BY 3 (LO);      {Convert to 1.15 format}
    AR=PASS SR1;
    IF LT AR=PASS AY0;                  {Saturate if needed}
    AF=PASS AX0;
    IF LT AR=-AR;                       {Negate output if needed}
    RTS;

{------------------------------------------------------------------------------
 -
 -  transmit interrupt used for Codec initialization
 -
 ------------------------------------------------------------------------------}
next_cmd:
        ena sec_reg;
        ax0 = dm (i3, m1);          { fetch next control word and }
        dm (tx_buf) = ax0;          { place in transmit slot 0    }
        ax0 = i3;
        ay0 = ^init_cmds;
        ar = ax0 - ay0;
        if gt rti;                  { rti if more control words still waiting }
        ax0 = 0xaf00;               { else set done flag and }
        dm (tx_buf) = ax0;          { remove MCE if done initialization }
        ax0 = 0;
        dm (stat_flag) = ax0;       { reset status flag }
        rti;


{******************************************************************************
 *  A high to low transition on flag_in signifies the start bit; it also
 *  triggers IRQ1 ISR which then turn on timer if the timer is off.  This is
 *  at to most 1/3 bit period too late but we should still catch the byte.
 ******************************************************************************}
irq1isr:
        pop sts;
        ena timer;              { start timer now }
        rts;                    { note rts }

nSend:  i4 = dm (PTR_TO_OUT_CHAR);        { send int }
        call (i4);

{ wait for char to go out }
nwt:
        ar = dm (CHAR_SEND_DONE_FLAG);
        none = pass ar;
        if eq jump nwt;

        rts;



.endmod;
